// H. Moessenboeck: Sprechen Sie Java? -- Kapitel 5, Aufgabe 3
// "Widerstandsberechnung"

public class A3 {
	// Grammar:
	//   Input  = Term {"+" Term}.
	//   Term   = Factor {"|" Factor}.
	//   Factor = number.
	
	static final int
		eof    = 0,
		number = 1,
		seq    = 2,  // operator for putting components in sequence
		par    = 3;  // operator for putting components in parallel
	
	static char ch;  // next input character
	static int val;  // value of previously recognized number
	static int sym;  // next input symbol

	// Scanner: read and analyze next input symbol
	static void scan() {
		while (ch <= ' ') ch = In.read();
		if (!In.done()) sym = eof;
		else if (ch == '+') {ch = In.read(); sym = seq;}
		else if (ch == '|') {ch = In.read(); sym = par;}
		else if (ch >= '0' && ch <= '9') {
			val = ch - '0'; ch = In.read();
			while (ch >= '0' && ch <= '9') {
				val = 10 * val + (ch - '0');
				ch = In.read();
			}
			sym = number;
		} else {
			Out.println("-- Ungueltiges Symbol in der Eingabe");
			System.exit(0);
		}
	}
	
	// Parser: analyze input file syntactically
	
	static float factor() {
		float r = 0;
		if (sym == number) {
			r = val; scan();
		} else {
			Out.println("-- Fehler in der Syntax der Eingabe");
			System.exit(0);
		}
		return r;
	}
	
	static float term() {
		float r = factor();
		if (sym == par) r = 1 / r;
		while (sym == par) {
			scan();
			float r1 = factor();
			r = r + 1 / r1;
		}
		return r;
	}
	
	static float resistance() {
		float r = term();
		while (sym == seq) {
			scan();
			float r1 = term();
			r = r + r1;
		}
		return r;
	}
	
	// main program
	
	public static void main(String[] arg) {
		In.open("input.txt");
		ch = ' '; scan();
		float r = resistance();
		Out.println("Gesamtwiderstand = " + r);
		In.close();
	}
}

/*
Sample input:
100 + 50 | 200 + 300
*/